#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_push_I16AX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=AX;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16BP(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=BP;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16BX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=BX;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16CX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=CX;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16DI(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=DI;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16DX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=DX;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16SI(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=SI;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16SP(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=SP;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg0=immdat;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u immdat;

immdat=*(imm+0);


arg0=(Bit8s)immdat;

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16rarm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16rarm323(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I16regm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x7));

push_16(arg0);
}

void BX_CPU_C::EXEC_push_I32EAX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EAX;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32EBP(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EBP;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32EBX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EBX;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32ECX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=ECX;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32EDI(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EDI;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32EDX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EDX;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32ESI(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=ESI;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32ESP(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=ESP;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32dsD16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32dsrm161(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32dsrm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32dsrm322D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg0=immdat;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit8u immdat;

immdat=*(imm+0);


arg0=(Bit8s)immdat;

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32r1rm161D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32r1rm161D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32r2rm162(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32r2rm162D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32r2rm162D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32rarm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32rarm323(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32rarm323D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32rarm323D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

push_32(arg0);
}

void BX_CPU_C::EXEC_push_I32regm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x7));

push_32(arg0);
}
